import { GridViewProps, GridViewState, IActionParam, IParam, MDView } from '@core';

/**
 * @description 表格视图
 * @export
 * @class GridView
 * @extends {MDView}
 */
export class GridView extends MDView {

  /**
   * @description 视图状态
   * @type {EditViewState}
   * @memberof GridView
   */
  public declare viewState: GridViewState;

  /**
   * 当前视图表格部件
   *
   * @type {IParam}
   * @memberof GridView
   */
  public declare grid: IParam;

  /**
   * @description 处理视图初始化
   *
   * @param {GridViewProps} props
   * @param {Function} emit
   * @memberof GridView
   */
  public useViewInit(props: GridViewProps, emit: Function) {
    super.useViewInit(props, emit);
    // 初始化搜索表格引用
    this.grid = ref(null);
  }

  /**
   * 处理部件事件
   *
   * @param {IActionParam} actionParam
   * @memberof MDView
   */
  public handleCtrlEvent(actionParam: IActionParam) {
    const { tag, action, data } = actionParam;
    if (Object.is(tag, 'grid')) {
      this.MDCtrlEvent(action, data);
    }
    super.handleCtrlEvent(actionParam);
  }

  /**
   *  获取多数据部件
   *
   * @return {*}  {*}
   * @memberof GridView
   */
  public getMDCtrl(): any {
    if (this.grid.value) {
      return this.grid.value;
    } else {
      return null;
    }
  }

  /**
   * @description 安装视图所有功能模块的方法
   * @param {GridViewProps} props 传入的Props
   * @param {Function} [emit] [emit] 事件
   * @return {*} 
   * @memberof GridView
   */
  public moduleInstall(props: GridViewProps, emit: Function) {
    const superParams = super.moduleInstall(props, emit);
    return {
      ...superParams,
      grid: this.grid
    };
  }
}
